import json
import xbmc
from . import common

class PhotoAlbum:
    def __init__(self, EmbyServer, SQLs):
        self.EmbyServer = EmbyServer
        self.SQLs = SQLs

    def update_SQLs(self, SQLs): # When paused, databases are closed and re-opened -> Update database
        self.SQLs = SQLs

    def change(self, Item, _):
        EmbyItem = Item.copy()
        common.set_path_filename(Item, self.EmbyServer.ServerData['ServerId'], None, False)
        self.SQLs["emby"].add_reference_photoalbum(Item['Id'], Item['LibraryId'], Item['ParentId'], Item['PresentationUniqueKey'], Item['Path'], Item['KodiFullPath'], json.dumps(EmbyItem))
        del EmbyItem
        xbmc.log(f"EMBY.core.photoalbum: ADD OR REPLACE {Item['Id']}: {Item['Path']}", 0) # DEBUGLOG
        return False

    def remove(self, Item, IncrementalSync):
        self.SQLs["emby"].remove_item(Item['Id'], "photoalbum", Item['LibraryId'])
        xbmc.log(f"EMBY.core.photoalbum: DELETE {Item['Id']}", int(IncrementalSync)) # LOG

    def userdata(self, Item, IncrementalSync, _UpdateKodiFavorite):
        xbmc.log(f"EMBY.core.photoalbum: USERDATA {Item['Id']}", int(IncrementalSync)) # LOG
        return False
